/*
 * "Hello World" example.
 *
 * This example prints 'Hello from Nios II' to the STDOUT stream. It runs on
 * the Nios II 'standard', 'full_featured', 'fast', and 'low_cost' example
 * designs. It runs with or without the MicroC/OS-II RTOS and requires a STDOUT
 * device in your system's hardware.
 * The memory footprint of this hosted application is ~69 kbytes by default
 * using the standard reference design.
 *
 * For a reduced footprint version of this template, and an explanation of how
 * to reduce the memory footprint for a given application, see the
 * "small_hello_world" template.
 *
 */
/*
#include <stdio.h>

int main()
{
  printf("Hello from Nios II!\n");

  return 0;
}
*/

#include <io.h>
#include <system.h>
#include <stdio.h>
#define IOWR_LED_DATA(base, offset, data) \
IOWR_16DIRECT(base, (offset) * 2, data)
#define IORD_LED_DATA(base, offset) \
IORD_16DIRECT(base, (offset) * 2)
#define IOWR_LED_SPEED(base, data) \
IOWR_16DIRECT(base + 32, 0, data)
int main()
{
    
    //set sram to 0 or anything else in order to change the volume
    IOWR_16DIRECT(SRAM_BASE, 0, 0x0000);
    
/*
int i;
printf("Hello Michael\n");
IOWR_LED_SPEED(LEDS_BASE, 0x0040);
for (i = 0 ; i < 8 ; i++) {
IOWR_LED_DATA(LEDS_BASE, i, 3 << (i * 2));
printf("writing %x\n", i);
}
for (i = 8 ; i < 16 ; i++) {
IOWR_LED_DATA(LEDS_BASE, i, 3 << (32 - (i * 2)));
printf("writing %x\n", i);
}
for (i = 0 ; i < 16 ; i++) {
printf("reading %x = %x\n", i,
IORD_LED_DATA(LEDS_BASE, i));
}
printf("Goodbye\n");
return 0;*/
}
